package gov.va.med.mhv.usermgmt.persist.hibernate;

import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.util.StringUtils;

import gov.va.med.mhv.usermgmt.bizobj.UserProfileBO;

/**
 * Custom extension of UserProfileDaoImpl necessary because the toolkit doesn't
 * support flexibile queries.
 *
 * @author Jon Crater May 11, 2006 1:16:26 PM
 */
public class UserProfileDaoCustomImpl extends UserProfileDaoImpl {

	public List getProfileByNameAndEmail(String firstName, String lastName, String email) {
		Criteria crit = getSession().createCriteria(UserProfileBO.class);
		
		if(StringUtils.hasText(firstName))
			crit.add(Restrictions.eq("firstName", firstName));
		
		if(StringUtils.hasText(lastName))
			crit.add(Restrictions.eq("lastName", lastName));
		
		if(StringUtils.hasText(email))
			crit.add(Restrictions.eq("contactInfoEmail", email));
		
		return crit.list();
	}
	
}